"use strict";
var hid = require('./hid');
var fs = require("fs");
var D = pxt.HWDBG;
function startAsync(compileRes) {
    return hid.initAsync()
        .then(function (d) {
        hid.connectSerial(d);
        D.postMessage = function (msg) {
            if (msg.subtype != "breakpoint") {
                console.log(msg);
                return;
            }
            var bmsg = msg;
            console.log("GLOBALS", bmsg.globals);
            for (var _i = 0, _a = bmsg.stackframes; _i < _a.length; _i++) {
                var s = _a[_i];
                console.log(s.funcInfo.functionName, s.locals);
            }
            var brkMatch = compileRes.breakpoints.filter(function (b) { return b.id == bmsg.breakpointId; })[0];
            if (!brkMatch) {
                console.log("Invalid breakpoint ID", msg);
                return;
            }
            var lines = fs.readFileSync(brkMatch.fileName, "utf8").split(/\n/);
            console.log(">>>", lines.slice(brkMatch.line, brkMatch.endLine + 1).join(" ;; "));
            Promise.delay(500)
                .then(function () { return D.resumeAsync(false); });
        };
        return D.startDebugAsync(compileRes, d);
    });
}
exports.startAsync = startAsync;
